package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;
import java.util.Collections;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.web.model.MyGoal;
import gov.va.med.mhv.mrp.web.model.MyGoalsExtension;
import gov.va.med.mhv.mrp.web.util.MyGoalsExtensionCompare;

@Component
public class MyGoalConverter implements Converter<MyGoalDTO, MyGoal>, Serializable {
	private static final long serialVersionUID = 1L;

	@Autowired
	private MyGoalExtensionsConverter myGoalExtensionsConverter;

	@Override
	public MyGoal convert(MyGoalDTO dto) {
		MyGoal model = new MyGoal();
		
		model.setCategory(dto.getCategory());
		model.setCompletedDate(dto.getCompletedDate());
		model.setCompletionType(dto.getCompletionType());
		model.setDescription(dto.getDescription());
		model.setEndDate(dto.getEndDate());
		model.setGoalId(dto.getGoalId());
		model.setGoalName(dto.getGoalName());
		model.setOplock(dto.getOplock());
		model.setPriorityType(dto.getPriorityType());
		model.setStartDate(dto.getStartDate());
		model.setStatus(dto.getStatus());
		model.setStatusMessage(model.getStatusMessage());
		model.setUserProfileId(dto.getUserProfileId());
		
		if (dto.getMyGoalsExtensions() != null) {
			for (MyGoalsExtensionDTO geDTO : dto.getMyGoalsExtensions()) {
				MyGoalsExtension ge = myGoalExtensionsConverter.convert(geDTO);
				model.getMyGoalsExtensions().add(ge);
			}
			
			Collections.sort(model.getMyGoalsExtensions(), new MyGoalsExtensionCompare());
			

		}
		return model;
	}

}
